"""A set of common constants."""
from __future__ import annotations

from enum import Enum, IntEnum
from pathlib import Path

import numpy as np

PACKAGE_PATH = Path(__file__).parent
ASSETS_PATH = PACKAGE_PATH.joinpath("envs", "xmls")
CACHE_PATH = Path.home() / ".bigym"

WORLD_MODEL = ASSETS_PATH / "world.xml"


class ActuatorGroup(IntEnum):
    """Enum class representing the actuator group."""

    BASE = 0
    LIMB = 1
    GRIPPER = 2


class HandSide(Enum):
    """Enum class representing the hand side."""

    LEFT = "Left"
    RIGHT = "Right"


TOLERANCE_ANGULAR = np.radians(2)
TOLERANCE_LINEAR = 0.0025
